%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: apply_n2o_conc_corr
%
% Scope:    apply N2O concentration correction
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           slope N2O concentration correction (double)
%           anchor gas name (string),
%           index plot requested (logical)
%
% Output:   corrected "bindata" and "binref" structures,
%           overview figures (if requested)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ref, binref, bindata] = apply_n2o_conc_corr(data,bindata, binref, gasnames, gastypeflag, slope_n2o, anchor_gas, plot_requested)

tic;fprintf('Running function apply_n2o_conc_corr...\n');
 
bindata_idx=2;     %N2O index
target_idx=4:6;   %d15N, d15Na, d15Nb index

ind_anchor=find(ismember(gasnames,anchor_gas));

%calculate intercept for given slopes (only needed for plotting, not used in correction)
y_anchor=NaN(1,width(target_idx));
intercept_n2o=NaN(1,width(target_idx));
for z=1:width(target_idx)
    y_anchor(1,z) = slope_n2o(1,z).*(1./binref.(gasnames{1,ind_anchor})(1,bindata_idx));
    intercept_n2o(1,z)=binref.(gasnames{1,ind_anchor})(1,target_idx(1,z)) - y_anchor(1,z);
end

axislabel={'1 / N_2O [ppb^{-1}]'};

%% plot data before correction

if plot_requested
    plot_n2o_conc_corr(data,bindata,binref,gasnames,bindata_idx,target_idx,slope_n2o,intercept_n2o,axislabel,ind_anchor,'Before N_2O concentration correction');
end
%% apply correction

for j=1:width(target_idx)
    for i=1:width(gastypeflag)
           bindata.(gasnames{1,i})(:,target_idx(1,j))=bindata.(gasnames{1,i})(:,target_idx(1,j))-slope_n2o(1,j)*((1./bindata.(gasnames{1,i})(:,bindata_idx))-(1./binref.(gasnames{1,ind_anchor})(1,bindata_idx)));
    end
    bindata.all(:,target_idx(1,j))=bindata.all(:,target_idx(1,j))-slope_n2o(1,j)*((1./bindata.all(:,bindata_idx))-(1./binref.(gasnames{1,ind_anchor})(1,bindata_idx)));
end

%% recalculate ref conditions

[ref, binref, bindata] = calc_ref_conditions(data,bindata,gasnames,gastypeflag);

%% plot data after correction
if plot_requested
    plot_n2o_conc_corr(data,bindata,binref,gasnames,bindata_idx,target_idx,slope_n2o,intercept_n2o,axislabel,ind_anchor,'After N_2O concentration correction');
end
%%
time_elapsed=toc; fprintf('apply_n2o_conc_corr completed (execution time: %1.2f s)\n',time_elapsed); 

end

